/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.tongfei.progressbar.DefaultProgressBarRenderer;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarRenderer;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.ProgressUpdateAction;
import me.tongfei.progressbar.Util;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedInputStream;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterable;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedIterator;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedOutputStream;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedReader;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedSpliterator;
import me.tongfei.progressbar.wrapped.ProgressBarWrappedWriter;

public class ProgressBar
implements AutoCloseable {
    private ProgressState progress;
    private ProgressUpdateAction action;
    private ScheduledFuture<?> scheduledTask;

    public ProgressBar(String task, long initialMax) {
        this(task, initialMax, 1000, false, System.err, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L, false, null, ChronoUnit.SECONDS, 0L, Duration.ZERO);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, boolean continuousUpdate, PrintStream os, ProgressBarStyle style, String unitName, long unitSize, boolean showSpeed, DecimalFormat speedFormat, ChronoUnit speedUnit, long processed, Duration elapsed) {
        this(task, initialMax, updateIntervalMillis, continuousUpdate, processed, elapsed, new DefaultProgressBarRenderer(style, unitName, unitSize, showSpeed, speedFormat, speedUnit), Util.createConsoleConsumer(os));
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, boolean continuousUpdate, long processed, Duration elapsed, ProgressBarRenderer renderer, ProgressBarConsumer consumer) {
        this.progress = new ProgressState(task, initialMax, processed, elapsed);
        this.action = new ProgressUpdateAction(this.progress, renderer, consumer, continuousUpdate);
        this.scheduledTask = Util.executor.scheduleAtFixedRate(this.action, 0L, updateIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public ProgressBar stepBy(long n) {
        this.progress.stepBy(n);
        return this;
    }

    public ProgressBar stepTo(long n) {
        this.progress.stepTo(n);
        return this;
    }

    public ProgressBar step() {
        this.progress.stepBy(1L);
        return this;
    }

    public ProgressBar maxHint(long n) {
        if (n < 0L) {
            this.progress.setAsIndefinite();
        } else {
            this.progress.setAsDefinite();
            this.progress.maxHint(n);
        }
        return this;
    }

    public ProgressBar pause() {
        this.progress.pause();
        return this;
    }

    public ProgressBar resume() {
        this.progress.resume();
        return this;
    }

    public ProgressBar reset() {
        this.progress.reset();
        return this;
    }

    @Override
    public void close() {
        this.scheduledTask.cancel(false);
        this.progress.kill();
        try {
            Util.executor.schedule(this.action, 0L, TimeUnit.NANOSECONDS).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public ProgressBar setExtraMessage(String msg) {
        this.progress.setExtraMessage(msg);
        return this;
    }

    public long getCurrent() {
        return this.progress.getCurrent();
    }

    public long getMax() {
        return this.progress.getMax();
    }

    public String getTaskName() {
        return this.progress.getTaskName();
    }

    public String getExtraMessage() {
        return this.progress.getExtraMessage();
    }

    public void refresh() {
        this.action.refresh();
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, String task) {
        return ProgressBar.wrap(it, new ProgressBarBuilder().setTaskName(task).setInitialMax(-1L));
    }

    public static <T> Iterator<T> wrap(Iterator<T> it, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedIterator<T>(it, pbb.build());
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, String task) {
        return ProgressBar.wrap(ts, new ProgressBarBuilder().setTaskName(task));
    }

    public static <T> Iterable<T> wrap(Iterable<T> ts, ProgressBarBuilder pbb) {
        long size = ts.spliterator().estimateSize();
        if (size != Long.MAX_VALUE) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedIterable<T>(ts, pbb);
    }

    public static InputStream wrap(InputStream is, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(is, pbb);
    }

    public static InputStream wrap(InputStream is, ProgressBarBuilder pbb) {
        long size = Util.getInputStreamSize(is);
        if (size != -1L && pbb.initialMaxIsSet()) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedInputStream(is, pbb.build());
    }

    public static OutputStream wrap(OutputStream os, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(os, pbb);
    }

    public static OutputStream wrap(OutputStream os, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedOutputStream(os, pbb.build());
    }

    public static Reader wrap(Reader reader, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(reader, pbb);
    }

    public static Reader wrap(Reader reader, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedReader(reader, pbb.build());
    }

    public static Writer wrap(Writer writer, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(writer, pbb);
    }

    public static Writer wrap(Writer writer, ProgressBarBuilder pbb) {
        return new ProgressBarWrappedWriter(writer, pbb.build());
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(sp, pbb);
    }

    public static <T> Spliterator<T> wrap(Spliterator<T> sp, ProgressBarBuilder pbb) {
        long size = sp.estimateSize();
        if (size != Long.MAX_VALUE) {
            pbb.setInitialMax(size);
        }
        return new ProgressBarWrappedSpliterator<T>(sp, pbb.build());
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(stream, pbb);
    }

    public static <T, S extends BaseStream<T, S>> Stream<T> wrap(S stream, ProgressBarBuilder pbb) {
        Spliterator<T> sp = ProgressBar.wrap(stream.spliterator(), pbb);
        return StreamSupport.stream(sp, stream.isParallel());
    }

    public static <T> Stream<T> wrap(T[] array, String task) {
        ProgressBarBuilder pbb = new ProgressBarBuilder().setTaskName(task);
        return ProgressBar.wrap(array, pbb);
    }

    public static <T> Stream<T> wrap(T[] array, ProgressBarBuilder pbb) {
        pbb.setInitialMax(array.length);
        return ProgressBar.wrap(Arrays.stream(array), pbb);
    }
}

